/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskPropertyChangedListener;
import filenet.vw.apps.taskman.VWTaskTabbedPane;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskField;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;

public class VWTaskTabPanel
extends JPanel
implements KeyListener,
ItemListener,
VWTaskPropertyChangedListener,
FocusListener {
    private EventListenerList m_listenerList = new EventListenerList();
    private Vector m_requiredTextFields = new Vector();
    private Vector m_taskSubPanels = new Vector();
    private boolean m_validationEnabled = true;
    private boolean m_bFireChangedEvents = true;
    private String m_helpPage = null;
    private Border m_textBorder = null;
    private static boolean m_setFocusOnFailedValidation = true;

    public VWTaskTabPanel() {
        super(true);
    }

    public VWTaskTabPanel(LayoutManager layout) {
        super(layout, true);
    }

    public VWTaskTabPanel(LayoutManager layout, String helpPage) {
        super(layout, true);
        this.m_helpPage = helpPage;
    }

    public void setFireTaskPropertyChangedEvents(boolean enabled) {
        this.m_bFireChangedEvents = enabled;
    }

    public String getHelpPage() {
        return this.m_helpPage;
    }

    public void setHelpPage(String helpTopic) {
        this.m_helpPage = helpTopic;
    }

    public void validateTextFields() throws VWException {
        if (this.m_validationEnabled) {
            int i;
            JTextComponent field = null;
            for (i = 0; i < this.m_requiredTextFields.size(); ++i) {
                field = (JTextComponent)this.m_requiredTextFields.get(i);
                this.validateTextField(field);
            }
            for (i = 0; i < this.m_taskSubPanels.size(); ++i) {
                Object component = this.m_taskSubPanels.get(i);
                if (component instanceof VWTaskTabPanel) {
                    ((VWTaskTabPanel)component).validateTextFields();
                    continue;
                }
                if (!(component instanceof VWTaskTabbedPane)) continue;
                ((VWTaskTabbedPane)component).validateProperties();
            }
        }
    }

    public void validateTextField(JTextComponent field) throws VWException {
        if (!this.m_validationEnabled) {
            return;
        }
        if (field.getText().trim().equals("") && field.isEnabled() && field.isEditable()) {
            if (VWTaskTabPanel.getSetFocusOnFailedValidation()) {
                this.requestFocus();
                field.requestFocus();
            }
            throw new VWException("vw.apps.taskman.MissingRequiredProperty", "A value must be entered for the ''{0}'' property.", field.getName());
        }
    }

    public static void setFocusOnFailedValidation(boolean value) {
        m_setFocusOnFailedValidation = value;
    }

    public static boolean getSetFocusOnFailedValidation() {
        return m_setFocusOnFailedValidation;
    }

    public void setValidationEnabled(boolean enabled) {
        this.m_validationEnabled = enabled;
    }

    public boolean getValidationEnabled() {
        return this.m_validationEnabled;
    }

    public void taskPropertyChanged(String propertyName) {
        this.fireVWTaskPropertyChangedEvent(new VWTaskPropertyChangedEvent((Object)this, propertyName));
    }

    public void taskPropertyChanged() {
        this.fireVWTaskPropertyChangedEvent(new VWTaskPropertyChangedEvent((Object)this, 0));
    }

    public void add(Component component, Object constraints) {
        super.add(component, constraints);
        this.processComponent(component);
    }

    public Component add(Component component, int index) {
        super.add(component, index);
        this.processComponent(component);
        return component;
    }

    public void add(Component component, Object constraints, int index) {
        super.add(component, constraints, index);
        this.processComponent(component);
    }

    public Component add(Component component) {
        super.add(component);
        this.processComponent(component);
        return component;
    }

    public void add(JTextComponent field, Object constraints, boolean required) {
        super.add((Component)field, constraints);
        this.processComponent(field);
        if (required) {
            this.m_requiredTextFields.add(field);
        }
    }

    public JTextComponent add(JTextComponent field, int index, boolean required) {
        super.add((Component)field, index);
        this.processComponent(field);
        if (required) {
            this.m_requiredTextFields.add(field);
        }
        return field;
    }

    public JTextComponent add(JTextComponent field, boolean required) {
        super.add(field);
        this.processComponent(field);
        if (required) {
            this.m_requiredTextFields.add(field);
        }
        return field;
    }

    private void processComponent(Component component) {
        if (component instanceof JTextComponent) {
            component.addKeyListener(this);
        } else if (component instanceof ItemSelectable) {
            ((ItemSelectable)((Object)component)).addItemListener(this);
        } else if (component instanceof VWTaskTabPanel) {
            ((VWTaskTabPanel)component).addVWTaskPropertyChangedListener(this);
            this.m_taskSubPanels.add(component);
        } else if (component instanceof VWTaskTabbedPane) {
            ((VWTaskTabbedPane)component).addVWTaskPropertyChangedListener(this);
            this.m_taskSubPanels.add(component);
        } else if (component instanceof VWToolbarBorder) {
            JPanel clientPanel = ((VWToolbarBorder)component).getClientPanel();
            if (clientPanel instanceof VWTaskTabPanel) {
                ((VWTaskTabPanel)clientPanel).addVWTaskPropertyChangedListener(this);
                this.m_taskSubPanels.add(clientPanel);
            }
        } else if (component instanceof JScrollPane) {
            this.processComponent(((JScrollPane)component).getViewport().getView());
        }
    }

    public void addVWTaskPropertyChangedListener(VWTaskPropertyChangedListener listener) {
        this.m_listenerList.add(VWTaskPropertyChangedListener.class, listener);
    }

    public void removeVWTaskPropertyChangedListener(VWTaskPropertyChangedListener listener) {
        this.m_listenerList.remove(VWTaskPropertyChangedListener.class, listener);
    }

    public void keyPressed(KeyEvent evt) {
        Object source = evt.getSource();
        int keyCode = evt.getKeyCode();
        if (!evt.isActionKey() && keyCode != 10) {
            if (source instanceof VWMaskField) {
                if (keyCode == 8 || Character.isDigit(evt.getKeyChar())) {
                    this.fireVWTaskPropertyChangedEvent(new VWTaskPropertyChangedEvent(source, ((Component)source).getName()));
                }
            } else {
                this.fireVWTaskPropertyChangedEvent(new VWTaskPropertyChangedEvent(source, ((Component)source).getName()));
            }
        }
    }

    public void keyReleased(KeyEvent evt) {
        this.keyPressed(evt);
    }

    public void keyTyped(KeyEvent evt) {
        this.keyPressed(evt);
    }

    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        this.fireVWTaskPropertyChangedEvent(new VWTaskPropertyChangedEvent(source, ((Component)source).getName()));
    }

    public void taskPropertyChanged(VWTaskPropertyChangedEvent evt) {
        this.fireVWTaskPropertyChangedEvent(evt);
    }

    public void fireVWTaskPropertyChangedEvent(VWTaskPropertyChangedEvent event) {
        if (event == null || !this.m_bFireChangedEvents) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != VWTaskPropertyChangedListener.class) continue;
            ((VWTaskPropertyChangedListener)listeners[i + 1]).taskPropertyChanged(event);
        }
    }

    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextField && !((JTextField)source).isEditable() || source instanceof JTextArea && !((JTextArea)source).isEditable()) {
            this.m_textBorder = ((JComponent)source).getBorder();
            ((JComponent)source).setBorder(BorderFactory.createEtchedBorder());
        }
    }

    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextField && !((JTextField)source).isEditable() || source instanceof JTextArea && !((JTextArea)source).isEditable()) {
            ((JComponent)source).setBorder(this.m_textBorder);
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   13 Jun 2008 08:51:06  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.14  $";
    }
}

